local super = require "Control"

Sandbox = super:new()

function Sandbox:new()
    self = super.new(self)
    
    self:addProperty('logic', '')
    self.logicFunction = function(self, canvas) end
    
    return self
end

function Sandbox:invalidate(sender)
    if sender == self:getPropertyHook('logic') then
        local logic = self:getProperty('logic')
        local func, message = loadstring('return function(self, canvas) ' .. logic .. ' end')
        if func then
            self.logicFunction = func and func()
        else
            warn(message)
        end
    end
    super.invalidate(self, sender)
end

function Sandbox:draw(canvas)
    canvas:pcall(function()
        self.logicFunction(self, canvas)
    end)
end

return Sandbox
